//*****************************************************************************
// INTEL CORPORATION PROPRIETARY INFORMATION
// This software is supplied under the terms of a license agreement or
// nondisclosure agreement with Intel Corporation and may not be 
// copied or disclosed except in accordance with the terms of that 
// agreement
//
// Copyright ?2010 Intel Corporation. All Rights Reserved.
//*****************************************************************************
#ifndef _SENSOR_INTERNAL_H_
#define _SENSOR_INTERNAL_H_

/*! "brief mipi port 
 *    MIPI interface can be used, same as ShCss_mipi_port
 */
#define MIPI_CSI2_PORT_0    0
#define MIPI_CSI2_PORT_1    1
#define MIPI_CSI2_PORT_2    2
#define MIPI_CSI2_PORT_3    3

#define MIPI_CSI2_3PH_PORTA     4
#define MIPI_CSI2_3PH_PORTB     5
#define MIPI_CSI2_PORT_0_SIP1   6
#define MIPI_CSI2_PORT_1_SIP1   7
#define MIPI_CSI2_PORT_2_SIP1   8
#define MIPI_CSI2_PORT_3_SIP1   9
#define MIPI_CSI2_3PH_PORTA_SIP1 10
#define MIPI_CSI2_3PH_PORTB_SIP1 11
#define MIPI_GEN_PORT0 12
#define MIPI_GEN_PORT1 13



/*! "brief mipi lanes 
 *    MIPI lane number
 */
#define MIPI_LANES_1        1
#define MIPI_LANES_2        2
#define MIPI_LANES_3        3
#define MIPI_LANES_4        4

/*! "brief bayer order 
 *    Bayer order for raw ouput. same as ShCss_bayer_order
 */
#define BAYER_ORDER_GRBG    0
#define BAYER_ORDER_RGGB    1
#define BAYER_ORDER_BGGR    2
#define BAYER_ORDER_GBRG    3
#define GRBG BAYER_ORDER_GRBG
#define RGGB BAYER_ORDER_RGGB
#define BGGR BAYER_ORDER_BGGR
#define GBRG BAYER_ORDER_GBRG

/*! "brief Binning Mode 
 */
#define BINNING_MODE_NONE   0
#define BINNING_MODE_2x2    1
#define BINNING_MODE_4x4    2
#define BINNING_MODE_3x3    3
#define BINNING1x1    1
#define BINNING2x2    2
#define BINNING3x3    3
#define BINNING4x4    4

/*! "brief sensor power sync mutex event 
 */
#define SENSOR_POWER_ON_EVENT_NAME        L"\\SensorPowerOnEventName"

/*! "brief sensor pld guid 
 */
static const GUID SensorPLD = 
{ 0x67C8E61C, 0x63AD, 0x48b4, { 0x93, 0x95, 0x13, 0x63, 0x31, 0x18, 0xB6, 0x83 } };

#define PLD_LENGTH 20
//#define SNSR_PLD_WORKAROUND


/*! "brief ISP side will set default timming to CSI reveiver
 */
#define DEFAULT_MIPI_BPS  0 

/*! "brief virtual channel
 */
#define VIRTUAL_CHANNEL_ID_0 0
#define VIRTUAL_CHANNEL_ID_1 1
#define VIRTUAL_CHANNEL_ID_2 2
#define VIRTUAL_CHANNEL_ID_3 3

/*! "brief DRIVER_STAGE
 */
typedef enum _DRIVER_STAGE_
{
    DRIVER_STAGE_LOADING,
    DRIVER_STAGE_WORKING,
    DRIVER_STAGE_NUM
} DRIVER_STAGE;

/*! "brief resolution max value
 */
#define RES_IMAGE_MAX 25
#define RES_VIDEO_MAX 25
#define RES_BAYER_MAX (RES_IMAGE_MAX+RES_VIDEO_MAX)

#define RESOLUTION_TABLE_END {0, 0, 0, 0, 0, 0, 0, 0, 0, NULL}
#define SKC_RESOLUTION_TABLE_END {0, 0, 0, 0, 0, 0, 0, 0}

/*! "brief mipi timing debug data structure
 */
#define iMIN 0
#define iMAX 1
typedef struct __MIPI_TIMING
{
    ULONG DataBps;
    ULONG MipiPClk;
    ULONG VCO;
    ULONG Clk_Prepare[2];
    ULONG Clk_Zero;
    ULONG Clk_Trail;
    ULONG Clk_Settle[2];   /*! (prepare + zero)/2*/
    ULONG Clk_Post;
    ULONG Hs_Prepare[2];
    ULONG Hs_Zero;
    ULONG Hs_Trail;
    ULONG Hs_Settle[2];    /*! (prepare + zero)/2*/
    ULONG Hs_Exit;
    ULONG Hs_EOT;
    ULONG Hs_REOT;
    ULONG Lpx_P;
} MIPI_TIMING;

#ifdef PIXTER_DEFINE
typedef struct __MIPI_TIMING_2
{
    ULONG mipi_clk;
    ULONG cont_hs_clk;
    ULONG timing_ovrd;
    ULONG pre;
    ULONG post;
    ULONG gap;
    ULONG ck_lpx;
    ULONG ck_prep;
    ULONG ck_zero;
    ULONG ck_trail;
    ULONG dat_lpx;
    ULONG dat_prep;
    ULONG dat_zero;
    ULONG dat_trail;
    ULONG twakeup;

    ULONG mipi_lanes_num;	/*! The number of mipi lanes */
} MIPI_TIMING2;

typedef struct pixter_vc_setting__
{
    UINT32 width;
    UINT32 height;
    UINT32 fps;
    enum pixter_image_format format;
} PIXTER_VC_SETTING;

typedef struct pixter_setting__ {
    UINT32 start;
    UINT32 end;
    UINT32 valid_vc_num;
    UINT32 def_vc;
    UINT32 block_mode;
    PIXTER_VC_SETTING vc[4];
} PIXTER_SETTING;

typedef struct pixter_fps_ {
    UINT32 fps_ovrd;
    UINT32 fps;
} PIXTER_FPS;

#endif

#endif
