//*****************************************************************************
// INTEL CORPORATION PROPRIETARY INFORMATION
// This software is supplied under the terms of a license agreement or
// nondisclosure agreement with Intel Corporation and may not be 
// copied or disclosed except in accordance with the terms of that 
// agreement
//
// Copyright ?2010 Intel Corporation. All Rights Reserved.
//*****************************************************************************

// The VCM is ad5816

#ifndef __VCM_AD5816__
#define __VCM_AD5816__

//focus
#define AD5816_VCM_IC_INFO             0x00 //read only
#define AD5816_VCM_IC_VERSION          0x01 //read only
#define AD5816_VCM_CONTROL             0x02
#define AD5816_VCM_CODE_MSB            0x03
#define AD5816_VCM_CODE_LSB            0x04
#define AD5816_VCM_STATUS              0x05 //read only
#define AD5816_VCM_MODE                0x06
#define AD5816_VCM_FREQ                0x07
#define AD5816_VCM_THRESHOLD           0x08

#define AD5816_MIN_FOCUS_POS        1
#define AD5816_MAX_FOCUS_POS        1023
#define AD5816_HOME_FOCUS_POS       AD5816_MIN_FOCUS_POS
#define AD5816_VCM_RUN_STEPS        32
#define AD5816_VCM_RESET_DELAY      1
#define AD5816_DEFAULT_POS  1


NTSTATUS AD5816_Init(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS AD5816_ResetPos(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS AD5816_SetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT FocusPos
    );

NTSTATUS AD5816_GetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT *FocusPos
    );

NTSTATUS AD5816_GetStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status    
    );

NTSTATUS AD5816_GetHPStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status    
    );

NTSTATUS AD5816_SetConfig(
    PVCM_CONTEXT pSsVcm,
    SNSR_VCMDATA* pSnsrVcmData
    );

#endif __VCM_AD5816__
