/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

// The VCM is LC898212AXB
#ifndef _VCM_LC898212AXB_
#define _VCM_LC898212AXB_

#define LC898212AXB_DEFAULT_POS          0xc452
#define LC898212AXB_MIN_FOCUS_POS        0    
#define LC898212AXB_MAX_FOCUS_POS        0xFFFF
#define LC898212AXB_HOME_FOCUS_POS       LC898212AXB_DEFAULT_POS
#define LC898212AXB_VCM_RUN_STEPS        32
#define LC898212AXB_VCM_RESET_DELAY      2
#define LC898212AXB_VCM_CODE         0x02
#define LC898212AXB_VCM_STATUS           0x0335
#define LC898212AXB_VCM_HALL_OFFSET_REG                  0x28
#define LC898212AXB_VCM_HALL_BIAS_REG                    0x29
#define LC898212AXB_VCM_START 0x04

//Register 80h `  9F
#define LC898212AXB_VCM_CLKSEL_211      0x80
#define LC898212AXB_VCM_ADSET_211       0x81
#define LC898212AXB_VCM_PWMSEL_211      0x82
#define LC898212AXB_VCM_SWTCH_211       0x83
#define LC898212AXB_VCM_STBY_211        0x84
#define LC898212AXB_VCM_CLR_211         0x85
#define LC898212AXB_VCM_DSSEL_211       0x86
#define LC898212AXB_VCM_ENBL_211        0x87
#define LC898212AXB_VCM_ANA1_211        0x88
#define LC898212AXB_VCM_AFSEND_211      0x8A
#define LC898212AXB_VCM_STMVEN_211      0x8A
#define LC898212AXB_VCM_STPT_211        0x8B
#define LC898212AXB_VCM_SWFC_211        0x8C
#define LC898212AXB_VCM_SWEN_211        0x8D
#define LC898212AXB_VCM_MSNUM_211       0x8E
#define LC898212AXB_VCM_MSSET_211       0x8F
#define LC898212AXB_VCM_DLYMON_211      0x90
#define LC898212AXB_VCM_MONA_211        0x91
#define LC898212AXB_VCM_PWMLIMIT_211    0x92
#define LC898212AXB_VCM_PINSEL_211      0x93
#define LC898212AXB_VCM_PWMSEL2_211     0x94
#define LC898212AXB_VCM_SFTRST_211      0x95
#define LC898212AXB_VCM_TEST_211        0x96    
#define LC898212AXB_VCM_PWMZONE2_211    0x97
#define LC898212AXB_VCM_PWMZONE1_211    0x98
#define LC898212AXB_VCM_PWMZONE0_211    0x99
#define LC898212AXB_VCM_ZONE3_211       0x9A
#define LC898212AXB_VCM_ZONE2_211       0x9B
#define LC898212AXB_VCM_ZONE1_211       0x9C
#define LC898212AXB_VCM_ZONE0_211       0x9D
#define LC898212AXB_VCM_GCTIM_211       0x9E
#define LC898212AXB_VCM_GCTIM_211NU     0x9F
#define LC898212AXB_VCM_STMINT_211      0xA0
#define LC898212AXB_VCM_STMVENDH_211    0xA1
#define LC898212AXB_VCM_STMVENDL_211    0xA2
#define LC898212AXB_VCM_MSNUMR_211      0xA3
#define LC898212AXB_VCM_ANA2_211        0xA4



// Convergence Judgement
#define LC898212AXB_VCM_INI_MSSET_211           (unsigned char)0x00     // Initialize Value For [8Fh]
#define LC898212AXB_VCM_CHTGX_THRESHOLD         (unsigned short)0x0200  // Convergence Judge Threshold
#define LC898212AXB_VCM_CHTGOKN_TIME            (unsigned char)0x80     // 64 Sampling Time 1.365msec( EQCLK=12MHz )
#define LC898212AXB_VCM_CHTGOKN_WAIT                3                   // CHTGOKN_WAIT(3ms) > CHTGOKN_TIME(2.732msec) ( CHTGOKN_WAIT has to be longer than CHTGOKN_TIME)

// StepMove
#define LC898212AXB_VCM_STMV_SIZE               (unsigned short)0x0180  // StepSize(MS1Z12)
#define LC898212AXB_VCM_STMV_INTERVAL           (unsigned char)0x01     // Step Interval(STMVINT)

#define LC898212AXB_VCM_STMCHTG_ON              (unsigned char)0x08     // STMVEN Register Set
#define LC898212AXB_VCM_STMSV_ON                (unsigned char)0x04
#define LC898212AXB_VCM_STMLFF_ON               (unsigned char)0x02 
#define LC898212AXB_VCM_STMVEN_ON               (unsigned char)0x01 
#define LC898212AXB_VCM_STMCHTG_OFF             (unsigned char)0x00
#define LC898212AXB_VCM_STMSV_OFF               (unsigned char)0x00
#define LC898212AXB_VCM_STMLFF_OFF              (unsigned char)0x00
#define LC898212AXB_VCM_STMVEN_OFF              (unsigned char)0x00

#define LC898212AXB_VCM_STMCHTG_SET             LC898212AXB_VCM_STMCHTG_ON              // Convergence Judgement On
#define LC898212AXB_VCM_STMSV_SET               LC898212AXB_VCM_STMSV_ON                // Setting Target Position = End Position
#define LC898212AXB_VCM_STMLFF_SET              LC898212AXB_VCM_STMLFF_OFF




//**************************
//	Definations 					
//**************************
// Delay RAM    00h ` 3eh

#define LC898212AXB_VCM_RZ_211H         0x04
#define LC898212AXB_VCM_RZ_211L         0x05
#define LC898212AXB_VCM_DZ1_211H        0x06
#define LC898212AXB_VCM_DZ1_211L        0x07
#define LC898212AXB_VCM_DZ2_211H        0x08
#define LC898212AXB_VCM_DZ2_211L        0x09
#define LC898212AXB_VCM_UZ1_211H        0x0A
#define LC898212AXB_VCM_UZ1_211L        0x0B
#define LC898212AXB_VCM_UZ2_211H        0x0C
#define LC898212AXB_VCM_UZ2_211L        0x0D
#define LC898212AXB_VCM_IZ1_211H        0x0E
#define LC898212AXB_VCM_IZ1_211L        0x0F
#define LC898212AXB_VCM_IZ2_211H        0x10
#define LC898212AXB_VCM_IZ2_211L        0x11
#define LC898212AXB_VCM_MS1Z01_211H     0x12
#define LC898212AXB_VCM_MS1Z01_211L     0x13
#define LC898212AXB_VCM_MS1Z11_211H     0x14
#define LC898212AXB_VCM_MS1Z11_211L     0x15
#define LC898212AXB_VCM_MS1Z12_211H     0x16
#define LC898212AXB_VCM_MS1Z12_211L     0x17
#define LC898212AXB_VCM_MS1Z22_211H     0x18
#define LC898212AXB_VCM_MS1Z22_211L     0x19
#define LC898212AXB_VCM_MS2Z01_211H     0x1A
#define LC898212AXB_VCM_MS2Z01_211L     0x1B
#define LC898212AXB_VCM_MS2Z11_211H     0x1C
#define LC898212AXB_VCM_MS2Z11_211L     0x1D
#define LC898212AXB_VCM_MS2Z12_211H     0x1E
#define LC898212AXB_VCM_MS2Z12_211L     0x1F
#define LC898212AXB_VCM_MS2Z22_211H     0x20
#define LC898212AXB_VCM_MS2Z22_211L     0x21
#define LC898212AXB_VCM_MS2Z23_211H     0x22
#define LC898212AXB_VCM_MS2Z23_211L     0x23
#define LC898212AXB_VCM_OZ1_211H        0x24
#define LC898212AXB_VCM_OZ1_211L        0x25
#define LC898212AXB_VCM_OZ2_211H        0x26
#define LC898212AXB_VCM_OZ2_211L        0x27
#define LC898212AXB_VCM_DAHLXO_211H     0x28
#define LC898212AXB_VCM_DAHLXO_211L     0x29
#define LC898212AXB_VCM_OZ3_211H        0x2A
#define LC898212AXB_VCM_OZ3_211L        0x2B
#define LC898212AXB_VCM_OZ4_211H        0x2C
#define LC898212AXB_VCM_OZ4_211L        0x2D
#define LC898212AXB_VCM_OZ5_211H        0x2E
#define LC898212AXB_VCM_OZ5_211L        0x2F



#define LC898212AXB_VCM_ms11a_211H      0x5A
#define LC898212AXB_VCM_ms11a_211L      0x5B
#define LC898212AXB_VCM_ms11c_211H      0x5C
#define LC898212AXB_VCM_ms11c_211L      0x5D
#define LC898212AXB_VCM_ms12a_211H      0x5E
#define LC898212AXB_VCM_ms12a_211L      0x5F
#define LC898212AXB_VCM_ms12c_211H      0x60
#define LC898212AXB_VCM_ms12c_211L      0x61


#define LC898212AXB_VCM_ms21c_211H  0x66
#define LC898212AXB_VCM_ms21c_211L  0x67
#define LC898212AXB_VCM_ms22a_211H  0x68
#define LC898212AXB_VCM_ms22a_211L  0x69
#define LC898212AXB_VCM_ms22c_211H  0x6A
#define LC898212AXB_VCM_ms22c_211L  0x6B
#define LC898212AXB_VCM_ms22d_211H  0x6C
#define LC898212AXB_VCM_ms22d_211L  0x6D
#define LC898212AXB_VCM_ms22e_211H  0x6E
#define LC898212AXB_VCM_ms22e_211L  0x6F
#define LC898212AXB_VCM_ms23p_211H  0x70
#define LC898212AXB_VCM_ms23p_211L  0x71

#define LC898212AXB_VCM_CHTGX_211H  0x7C
#define LC898212AXB_VCM_CHTGX_211L  0x7D
#define LC898212AXB_VCM_CHTGN_211H  0x7E
#define LC898212AXB_VCM_CHTGN_211L  0x7F



typedef struct STMVPAR {
    UINT16  UsSmvSiz ;
    UINT8   UcSmvItv ;
    UINT8   UcSmvEnb ;
} stSmvPar ;


/* Step Move Parameter Setting Function */
NTSTATUS LC898212AXB_StmvSet(PVCM_CONTEXT pSsVcm, stSmvPar param);

/* Step Move to Target Positon Function */
NTSTATUS LC898212AXB_StmvTo(PVCM_CONTEXT pSsVcm, INT16 SsSmvEnd);

NTSTATUS LC898212AXB_StmvEnd(PVCM_CONTEXT pSsVcm, UINT8 UcParMod);


NTSTATUS LC898212AXB_Init(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS LC898212AXB_ResetPos(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS LC898212AXB_SetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT FocusPos
    );

NTSTATUS LC898212AXB_GetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT *FocusPos
    );

NTSTATUS LC898212AXB_GetStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status    
    );

NTSTATUS LC898212AXB_GetHPStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status    
    );

NTSTATUS LC898212AXB_SetConfig(
    PVCM_CONTEXT pSsVcm,
    SNSR_VCMDATA* pSnsrVcmData
    );

#endif __VCM_LC898212AXB__
